<div class="filament-hidden">

![header](./.github/resources/pxlrbt-changelog.png)
    
</div>

# Filament Changelog

Filament Changelog allows you to display your GitHub releases in your Filament admin panel. It fetches your latest releases from GitHub and downloads the assets that are inside the body of the release to your public storage.

## Installation

```shell
composer require pxlrbt/filament-changelog
```

## Configuration
Enable the plugin by adding the following code to your PanelProvider. Provide your GitHub repo and a personal access token via `->github()` method. You can find more info on how to create an access token via the [GitHub Docs](https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-personal-access-token-classic).

```php
$panel->plugins([
    ChangelogPlugin::make()
        ->github('REPO', 'TOKEN');
])
```

You should add `php artisan changelog:get` to your deployment script to fetch the latest releases from GitHub.

You can track the user's last viewed release tag by using the `->trackUserVersion()` method.

```php
$panel->plugins([
    ChangelogPlugin::make()
        ->github('REPO', 'TOKEN')
        ->trackUserVersion('user_column');
])
```

## Page
You can add the changelog page to your panel via your PanelProvider:

```php
$panel->pages([
    pxlrbt\FilamentChangelog\Pages\ChangelogPage::class,
]);
```

### Badge

The page has a version badge that will display the latest release tag. The badge will always show. If you only want to show it, when the user hasn't viewed the changelog yet, you can use the `->trackUserVersion()` method.

## New Version Modal
You can enable the "new version modal" via the Plugin object. This will display a modal to the user when a new version is available. This feature also requires that your user model has a column to store the last viewed release tag and enable it via the `->trackUserVersion()` method.
    
```php
$panel->plugins([
    ChangelogPlugin::make()
        ->enableNewVersionModal()
        ->trackUserVersion('user_column');
])
```

## Widget
Use the changelog widget by adding it to your PanelProvider:

```php
$panel->widgets([
    pxlrbt\FilamentChangelog\Widgets\ChangelogWidget::class,
]);
```

## Customisation

### Filtering Releases

Sometimes you may want to filter the releases that are displayed in the changelog. You can do so by using the `Changelog::filterReleasesUsing()` method in a service provider.

```php
Changelog::filterReleasesUsing(function (Release $release) {
    return version_compare(trim($release->tag, 'v'), '1.4.8', '>');
});
```

### Overriding views
You can override the views by publishing the package views to your resources folder. For example you can customize the release feed by overriding copying `partials/releases.blade.php` to `resources/views/vendor/filament-changelog/partials/releases.blade.php`.

### Release asset storage
You can configure the storage for the cached GitHub assets by publishing the config file and using the `storage` config key.

```shell
php artisan vendor:publish --provider="pxlrbt\FilamentChangelog\FilamentChangelogServiceProvider" --tag="config"
```
