<div class="fi-changelog releases flex flex-col gap-8">
    @foreach($releases as $release)
        <div class="fi-changelog-release divide-y divide-gray-100">
            <div class="flex items-center justify-between pb-2">
                <h2 class="font-bold text-2xl">{{ $release->name }}</h2>

                <x-filament::badge>{{ $release->publishedAt()->format('d.m.Y') }}</x-filament::badge>
            </div>

            <div class="prose dark:prose-invert max-w-full pt-2">{!! $release->body() !!}</div>
        </div>
    @endforeach
</div>

<style>
    .prose img {
        border-radius: 0.5rem;
        border: 1px solid #e1e1e1;
        box-shadow: 0 0 4px 0 rgba(0, 0, 0, 0.1);
    }
</style>

