<?php

namespace pxlrbt\FilamentChangelog\Actions;

use Illuminate\Support\Facades\Storage;
use pxlrbt\FilamentChangelog\DataObjects\Release;
use pxlrbt\FilamentChangelog\GithubConnector;

class DownloadAssetsAction
{
    public function __invoke(Release $release)
    {
        $client = app(GithubConnector::class);
        $assetBaseUrl = "https://github.com/{$client->getRepo()}/assets";

        preg_match_all('|'.$assetBaseUrl.'/([a-z0-9\-/]*)|', $release->body, $matches);

        foreach ($matches[1] as $filename) {
            $disk = config('filament-changelog.storage.disk');
            $path = config('filament-changelog.storage.path');

            if (Storage::disk($disk)->exists($path.'/'.$filename)) {
                continue;
            }

            $response = $client
                ->withHeader('Accept', 'application/octet-stream')
                ->get('https://github.com/pxlrbt/veser-web/assets/'.$filename);

            if ($response->successful()) {
                Storage::disk($disk)->put($path.'/'.$filename, $response->body());
            }
        }
    }
}
