<?php

namespace pxlrbt\FilamentChangelog;

use Livewire;
use pxlrbt\FilamentChangelog\Console\ClearChangelogCommand;
use pxlrbt\FilamentChangelog\Console\GetChangelogCommand;
use pxlrbt\FilamentChangelog\Livewire\NewVersionModal;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class ChangelogServiceProvider extends PackageServiceProvider
{
    public static string $name = 'filament-changelog';

    public function register()
    {
        Livewire::component(static::$name.'::changelog.new-version-modal', NewVersionModal::class);

        return parent::register();
    }

    public function configurePackage(Package $package): void
    {
        $package
            ->name(static::$name)
            ->hasViews()
            ->hasConfigFile()
            ->hasTranslations()
            ->hasCommands([
                GetChangelogCommand::class,
                ClearChangelogCommand::class,
            ]);
    }
}
