<?php

namespace pxlrbt\FilamentChangelog\Filament\Actions;

use Filament\Actions\Action;
use Filament\Support\Enums\ActionSize;
use pxlrbt\FilamentChangelog\Changelog;

class ChangelogAction extends Action
{
    public static function getDefaultName(): ?string
    {
        return 'changelog';
    }

    protected function setUp(): void
    {
        parent::setUp();

        $this
            ->label(__('filament-changelog::widget.action.label'))

            ->slideOver()
            ->outlined()
            ->size(ActionSize::ExtraSmall)

            ->mountUsing(fn () => Changelog::markAsViewed())
            ->modalHeading(__('filament-changelog::widget.modal.heading'))
            ->modalContent(view('filament-changelog::widget-modal'))
            ->modalSubmitAction(false)
            ->modalCancelActionLabel(__('filament-changelog::widget.modal.close'));
    }
}
