<?php

namespace pxlrbt\FilamentChangelog\Filament\Widgets;

use Filament\Actions\Action;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Actions\Contracts\HasActions;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Widgets\Widget;
use Livewire\Attributes\Computed;
use pxlrbt\FilamentChangelog\Changelog;
use pxlrbt\FilamentChangelog\Filament\Actions\ChangelogAction;

class ChangelogWidget extends Widget implements HasActions, HasForms
{
    use InteractsWithActions;
    use InteractsWithForms;

    protected static bool $isLazy = false;

    protected static string $view = 'filament-changelog::widget';

    #[Computed]
    public function label(): string
    {
        return __('filament-changelog::widget.title');
    }

    #[Computed]
    public function version(): string
    {
        return Changelog::latestTag();
    }

    public function changelogAction(): Action
    {
        return ChangelogAction::make();
    }
}
