<?php

namespace pxlrbt\FilamentChangelog;

use Filament\Contracts\Plugin;
use Filament\Panel;
use Filament\Support\Colors\Color;
use Filament\View\PanelsRenderHook;
use Livewire;
use pxlrbt\FilamentChangelog\Connectors\GithubConnector;
use pxlrbt\FilamentChangelog\Livewire\NewVersionModal;

class ChangelogPlugin implements Plugin
{
    public bool $showNewVersionModal = false;

    public bool $showVersionBadge = false;

    public array|string $versionBadgeColor = Color::Blue;

    public ?string $userVersionColumn = null;

    public string $modalComponent = NewVersionModal::class;

    public static function make()
    {
        return new static;
    }

    public function getId(): string
    {
        return 'pxlrbt/filament-changelog';
    }

    public function register(Panel $panel): void
    {
        if ($this->showNewVersionModal) {
            $panel->renderHook(PanelsRenderHook::PAGE_END, function () {
                if (! Changelog::hasUserSeenLatest()) {
                    return Livewire::mount($this->modalComponent);
                }
            });
        }

        if ($this->showVersionBadge) {
            $panel->renderHook(PanelsRenderHook::GLOBAL_SEARCH_BEFORE, function () {
                return view('filament-changelog::topbar-badge', [
                    'version' => Changelog::latestTag(),
                    'color' => $this->versionBadgeColor,
                ]);
            });
        }
    }

    public function boot(Panel $panel): void
    {
        //
    }

    public function github(string $repo, string $token): static
    {
        app()->singleton(GithubConnector::class, fn () => new GithubConnector($token, $repo));

        return $this;
    }

    public function trackUserVersion(string $column = 'last_seen_version'): static
    {
        $this->userVersionColumn = $column;

        return $this;
    }

    public function showNewVersionModal(?string $component = null): static
    {
        $this->showNewVersionModal = true;
        $this->modalComponent = $component ?? NewVersionModal::class;

        return $this;
    }

    public function showVersionBadge(array|string $color = Color::Blue): static
    {
        $this->showVersionBadge = true;
        $this->versionBadgeColor = $color;

        return $this;
    }
}
