<?php

namespace pxlrbt\FilamentChangelog\Connectors;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Traits\ForwardsCalls;

class GithubConnector
{
    use ForwardsCalls;

    protected $client;

    public static string $baseUrl = 'https://api.github.com/';

    public function __construct(
        protected string $token,
        protected string $repo,
    ) {
        $this->client = Http::baseUrl(self::$baseUrl)
            ->withToken($this->token, 'token')
            ->withHeader('Accept', 'application/vnd.github.v3+json');
    }

    public function __call(string $name, array $arguments)
    {
        return $this->forwardCallTo($this->client, $name, $arguments);
    }

    public function getRepo(): string
    {
        return $this->repo;
    }
}
