<?php

namespace pxlrbt\FilamentChangelog\Filament\Pages;

use Filament\Pages\Page;
use Illuminate\Contracts\Support\Htmlable;
use Illuminate\Support\Collection;
use Livewire\Attributes\Computed;
use pxlrbt\FilamentChangelog\Changelog;

class ChangelogPage extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament-changelog::page';

    protected ?string $maxContentWidth = '5xl';

    public function mount()
    {
        Changelog::markAsViewed();
    }

    public function getTitle(): string|Htmlable
    {
        return __('filament-changelog::page.title');
    }

    public function getHeading(): string|Htmlable
    {
        return __('filament-changelog::page.heading');
    }

    public static function getNavigationLabel(): string
    {
        return __('filament-changelog::page.navigation_label');
    }

    public static function getNavigationBadge(): ?string
    {
        if (static::shouldShowBadge()) {
            return Changelog::releases()->first()?->tag;
        }

        return null;
    }

    public static function shouldShowBadge(): bool
    {
        return ! Changelog::hasUserSeenLatest();
    }

    #[Computed]
    public function releases(): Collection
    {
        return Changelog::releases();
    }
}
