<?php

namespace pxlrbt\FilamentChangelog\Livewire;

use Illuminate\Support\Collection;
use Livewire\Attributes\Computed;
use Livewire\Component;
use pxlrbt\FilamentChangelog\Changelog;
use pxlrbt\FilamentChangelog\DataObjects\Release;

class NewVersionModal extends Component
{
    #[Computed]
    public function heading(): string
    {
        return __('filament-changelog::modal.heading');
    }

    #[Computed]
    public function releases(): Collection
    {
        return Changelog::releases()->where(function (Release $release) {
            return version_compare($release->tag, Changelog::lastSeenVersion(), '>');
        });
    }

    public function markAsViewed(): void
    {
        Changelog::markAsViewed();
    }

    public function render()
    {
        return view('filament-changelog::new-version-modal');
    }
}
